import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { PaymentMethod, SaleStatus } from '@prisma/client';

export class SaleItemResponseDto {
  @ApiProperty({
    description: 'Sale item ID',
    example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
  })
  id: string;

  @ApiProperty({
    description: 'Product ID',
    example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
  })
  productId: string;

  @ApiProperty({
    description: 'Product name (snapshot)',
    example: 'Premium Coffee Beans',
  })
  productName: string;

  @ApiProperty({
    description: 'Product SKU (snapshot)',
    example: 'PCB-001',
  })
  productSku: string;

  @ApiProperty({
    description: 'Quantity sold',
    example: 2,
  })
  quantity: number;

  @ApiProperty({
    description: 'Unit price at time of sale',
    example: 29.99,
  })
  unitPrice: number;

  @ApiProperty({
    description: 'Total price for this item',
    example: 59.98,
  })
  totalPrice: number;

  @ApiProperty({
    description: 'Item creation timestamp',
    example: '2024-01-15T10:30:00.000Z',
  })
  createdAt: Date;
}

export class SaleResponseDto {
  @ApiProperty({
    description: 'Sale ID',
    example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
  })
  id: string;

  @ApiProperty({
    description: 'Tenant ID',
    example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
  })
  tenantId: string;

  @ApiProperty({
    description: 'Unique sale number',
    example: '20240115-0001',
  })
  saleNumber: string;

  @ApiPropertyOptional({
    description: 'Customer name',
    example: 'John Doe',
  })
  customerName?: string;

  @ApiPropertyOptional({
    description: 'Customer email',
    example: 'john@example.com',
  })
  customerEmail?: string;

  @ApiPropertyOptional({
    description: 'Customer phone',
    example: '+1234567890',
  })
  customerPhone?: string;

  @ApiProperty({
    description: 'Subtotal before tax and discounts',
    example: 59.98,
  })
  subtotal: number;

  @ApiProperty({
    description: 'Tax amount',
    example: 4.80,
  })
  taxAmount: number;

  @ApiProperty({
    description: 'Discount amount',
    example: 5.00,
  })
  discountAmount: number;

  @ApiProperty({
    description: 'Final total amount',
    example: 59.78,
  })
  total: number;

  @ApiProperty({
    description: 'Payment method used',
    enum: PaymentMethod,
    example: 'CASH',
  })
  paymentMethod: PaymentMethod;

  @ApiProperty({
    description: 'Sale status',
    enum: SaleStatus,
    example: 'COMPLETED',
  })
  status: SaleStatus;

  @ApiPropertyOptional({
    description: 'Additional notes',
    example: 'Customer requested gift wrap',
  })
  notes?: string;

  @ApiPropertyOptional({
    description: 'ID of user who processed the sale',
    example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
  })
  processedBy?: string;

  @ApiProperty({
    description: 'Sale creation timestamp',
    example: '2024-01-15T10:30:00.000Z',
  })
  createdAt: Date;

  @ApiProperty({
    description: 'Sale update timestamp',
    example: '2024-01-15T10:30:00.000Z',
  })
  updatedAt: Date;

  @ApiProperty({
    description: 'Sale items',
    type: [SaleItemResponseDto],
  })
  saleItems: SaleItemResponseDto[];
}

export class SalesSummaryDto {
  @ApiProperty({
    description: 'Total number of sales',
    example: 150,
  })
  totalSales: number;

  @ApiProperty({
    description: 'Total revenue',
    example: 12500.50,
  })
  totalRevenue: number;

  @ApiProperty({
    description: 'Average sale amount',
    example: 83.34,
  })
  averageSaleAmount: number;

  @ApiProperty({
    description: 'Today sales count',
    example: 15,
  })
  todaySales: number;

  @ApiProperty({
    description: 'Today revenue',
    example: 1250.75,
  })
  todayRevenue: number;
}