import { SalesService } from './sales.service';
import { CreateSaleDto } from './dto/create-sale.dto';
import { SaleResponseDto, SalesSummaryDto } from './dto/sale-response.dto';
import { AuthenticatedUser } from '../auth/guards/tenant.guard';
import { SaleStatus } from '@prisma/client';
export declare class SalesController {
    private readonly salesService;
    private readonly logger;
    constructor(salesService: SalesService);
    create(createSaleDto: CreateSaleDto, user: AuthenticatedUser): Promise<SaleResponseDto>;
    findAll(page: number, limit: number, status?: SaleStatus, startDateStr?: string, endDateStr?: string, user: AuthenticatedUser): Promise<{
        sales: SaleResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getSummary(user: AuthenticatedUser): Promise<SalesSummaryDto>;
    findOne(id: string, user: AuthenticatedUser): Promise<SaleResponseDto>;
    findBySaleNumber(saleNumber: string, user: AuthenticatedUser): Promise<SaleResponseDto>;
    getDailySales(dateStr: string, user: AuthenticatedUser): Promise<{
        sales: SaleResponseDto[];
        total: number;
    }>;
}
