"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesSummaryDto = exports.SaleResponseDto = exports.SaleItemResponseDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const client_1 = require("@prisma/client");
class SaleItemResponseDto {
}
exports.SaleItemResponseDto = SaleItemResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale item ID',
        example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
    }),
    __metadata("design:type", String)
], SaleItemResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product ID',
        example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
    }),
    __metadata("design:type", String)
], SaleItemResponseDto.prototype, "productId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product name (snapshot)',
        example: 'Premium Coffee Beans',
    }),
    __metadata("design:type", String)
], SaleItemResponseDto.prototype, "productName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product SKU (snapshot)',
        example: 'PCB-001',
    }),
    __metadata("design:type", String)
], SaleItemResponseDto.prototype, "productSku", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Quantity sold',
        example: 2,
    }),
    __metadata("design:type", Number)
], SaleItemResponseDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unit price at time of sale',
        example: 29.99,
    }),
    __metadata("design:type", Number)
], SaleItemResponseDto.prototype, "unitPrice", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total price for this item',
        example: 59.98,
    }),
    __metadata("design:type", Number)
], SaleItemResponseDto.prototype, "totalPrice", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Item creation timestamp',
        example: '2024-01-15T10:30:00.000Z',
    }),
    __metadata("design:type", Date)
], SaleItemResponseDto.prototype, "createdAt", void 0);
class SaleResponseDto {
}
exports.SaleResponseDto = SaleResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale ID',
        example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tenant ID',
        example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "tenantId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique sale number',
        example: '20240115-0001',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "saleNumber", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Customer name',
        example: 'John Doe',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "customerName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Customer email',
        example: 'john@example.com',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "customerEmail", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Customer phone',
        example: '+1234567890',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "customerPhone", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Subtotal before tax and discounts',
        example: 59.98,
    }),
    __metadata("design:type", Number)
], SaleResponseDto.prototype, "subtotal", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tax amount',
        example: 4.80,
    }),
    __metadata("design:type", Number)
], SaleResponseDto.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Discount amount',
        example: 5.00,
    }),
    __metadata("design:type", Number)
], SaleResponseDto.prototype, "discountAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Final total amount',
        example: 59.78,
    }),
    __metadata("design:type", Number)
], SaleResponseDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Payment method used',
        enum: client_1.PaymentMethod,
        example: 'CASH',
    }),
    __metadata("design:type", typeof (_a = typeof client_1.PaymentMethod !== "undefined" && client_1.PaymentMethod) === "function" ? _a : Object)
], SaleResponseDto.prototype, "paymentMethod", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale status',
        enum: client_1.SaleStatus,
        example: 'COMPLETED',
    }),
    __metadata("design:type", typeof (_b = typeof client_1.SaleStatus !== "undefined" && client_1.SaleStatus) === "function" ? _b : Object)
], SaleResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Additional notes',
        example: 'Customer requested gift wrap',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "notes", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'ID of user who processed the sale',
        example: 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11',
    }),
    __metadata("design:type", String)
], SaleResponseDto.prototype, "processedBy", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale creation timestamp',
        example: '2024-01-15T10:30:00.000Z',
    }),
    __metadata("design:type", Date)
], SaleResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale update timestamp',
        example: '2024-01-15T10:30:00.000Z',
    }),
    __metadata("design:type", Date)
], SaleResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Sale items',
        type: [SaleItemResponseDto],
    }),
    __metadata("design:type", Array)
], SaleResponseDto.prototype, "saleItems", void 0);
class SalesSummaryDto {
}
exports.SalesSummaryDto = SalesSummaryDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total number of sales',
        example: 150,
    }),
    __metadata("design:type", Number)
], SalesSummaryDto.prototype, "totalSales", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total revenue',
        example: 12500.50,
    }),
    __metadata("design:type", Number)
], SalesSummaryDto.prototype, "totalRevenue", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Average sale amount',
        example: 83.34,
    }),
    __metadata("design:type", Number)
], SalesSummaryDto.prototype, "averageSaleAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Today sales count',
        example: 15,
    }),
    __metadata("design:type", Number)
], SalesSummaryDto.prototype, "todaySales", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Today revenue',
        example: 1250.75,
    }),
    __metadata("design:type", Number)
], SalesSummaryDto.prototype, "todayRevenue", void 0);
//# sourceMappingURL=sale-response.dto.js.map